function [ F ] = Q_FNodal( Ntri, Nodes, c )
%Given nodal values of spline, output it formatted for plotting
%   c is a column vector specifying values of spline at Nodes and indexed
%   like it.  We use Ntri and the others to pass to our usual FSample
%   format.

numtri = size(Ntri,1);
F = zeros(numtri,6,3); 

%F(i,:,1:2) is ith triangle and its 6 nodals with 1 the x and 2 the y

%Evaluate Nodes(:,1) and Nodes(:,2) @ Ntri's values
for i=1:numtri
    for j=1:6
        F(i,j,1) = Nodes(Ntri(i,j),1);
    end
end

for i=1:numtri
    for j=1:6
        F(i,j,2) = Nodes(Ntri(i,j),2);
    end
end

for i=1:numtri
    for j=1:6
        F(i,j,3) = c(Ntri(i,j),1);
    end
end


end
